
-- BALLOON PARAMETERS
kPPS = 1000 ;               -- Number of particles generated per second
kGravity = 1000 ;            -- Gravity in pixels/second/second

--THIS IS A LIST OF THE TYPES OF LIGHTING MODES
-- kBlendNormal
-- kBlendOpaque
-- kBlendAdditive
-- kBlendAdditiveAlpha
-- kBlendSubtractive
-- kBlendLit

--THIS BLOCK SETS THE CREATION PARAMETERS
function Init()
  SetTexture("balloon"); --the file named balloon will be the particle used
  SetBlendMode(kBlendLit); --this uses the lit mode, necessary for the color effects
  SetNumParticles(15); -- fifteen particles will be created
end

floor = math.floor

ParticlesPerSecond = NewParticleGenerator();

StopSpouting = NewTimeout(500); --particles will only be created for 500 milliseconds
TestDone = NewTimeout(4000); --the particles will last for 4 seconds

--THIS BLOCK CREATES THE NEW PARTICLES
function Update(ms)
  if (TestDone(ms)) then
    SetDone();
    return ;
  end
  local newParticles = ParticlesPerSecond( kPPS,ms );

--THIS BLOCK SETS THE CREATION PARAMETERS
  if (not StopSpouting(ms)) then
   
   --set the spawn range, a rectangle from -5, -10 to 5, 10
   InitPosition( "vRange", Vec3(-5, -10), Vec3(5, 10) );

   --set the speed of particles, speed in the x direction is between -40 and 40, speed in the y direction is between 10 and 40 (positive y is down)
   InitVelocity( "vRange", Vec3(-40,10), Vec3(40,40) );

   --sets the range of paricle sizes, balloons are scaled between 35% and 60%
   InitScale( "fRange", 0.35, .6 );

   --sets the colors, a color is defined: Color(red, green, blue, alpha)
   InitColor("cSelect",Color(0,1,1,.8), Color(1,.2,.1,.8), Color(1,1,0,.8), Color(0,1,0,.8) );

   --creates the particles
   CreateParticles(newParticles);
  end

  --THIS BLOCK SETS THE UPDATE PARAMETERS
   -- gravity is negative in this particle so balloons will float up
   Gravity(-.15* kGravity);

   -- clip particles off the bottom of the screen
   Do("clipy",320);

   --moves the particles
   Do("move");

   --ages the particles
   DoAge("iAge")


end